<?php

namespace App\Http\Controllers;

use App\Checklist\CheckMail;
use App\Checklist\CheckPrimaryDomain;
use App\Checklist\CheckPrimaryDomainSsl;
use Illuminate\Http\Request;
use Stancl\Tenancy\Database\Models\Domain;

class ChecklistController extends Controller
{
    public function checkDomain(Domain $domain, CheckPrimaryDomain $check)
    {
        return [
            'status' => $check->performCheck($domain)
        ];
    }

    public function checkMail(CheckMail $check)
    {
        return [
            'status' => $check->checkConnection()
        ];
    }
}
