<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ConditionFilterDisplaySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Show Condition filter (new/used/ex-demo)',
                'config_key' => 'automotive-vehicle-show-condition',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
