<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ImaginStudioColourImportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Import Colour Data',
                'config_key' => 'imagin-placeholders-import-colour-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
