<?php

namespace Tests\Unit;

use App\Facades\Settings;
use Database\Seeders\Tenant\FinanceSettingSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Facades\Bus;
use Mtc\MercuryDataModels\Finance\Jobs\FetchVehicleFinanceData;
use Mtc\MercuryDataModels\Services\FinanceService;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class FinanceServiceTest extends TestCase
{
    use DatabaseMigrations;

    protected $tenancy = true;

    public function testPercentageDeposit()
    {
        Bus::fake();

        $this->seed(FinanceSettingSeeder::class);
        Settings::update('finance-codeweavers-enabled', true);
        Settings::update('finance-codeweavers-api_key', 'foo-baz-bar');
        Settings::update('finance-codeweavers-username', 'lorem');
        Settings::update('finance-codeweavers-password', 'ipsum');
        Settings::update('finance-deposit_percentage', 10);

        $vehicle = Vehicle::factory()->create([
            'price' => 1000,
        ]);

        $data = [
            'term' => 60,
            //'deposit' => 100,
            'annual_mileage' => 8000,
            'credit_rating' => '',
        ];

        (new FinanceService())->request($vehicle, $data);

        // assert that the deposit is calculated as a percentage of the vehicle price
        Bus::assertDispatched(function (FetchVehicleFinanceData $job) {
            return $job->deposit == 100;
        });
    }

    public function testPercentageDepositWithMinimum()
    {
        Bus::fake();

        $this->seed(FinanceSettingSeeder::class);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Finance',
            'group' => 'General',
            'name' => 'Minimum default deposit amount',
            'config_key' => 'finance-minimum-deposit-amount',
            'type' => 'int',
            'value' => 999,
        ]);

        Settings::update('finance-codeweavers-enabled', true);
        Settings::update('finance-codeweavers-api_key', 'foo-baz-bar');
        Settings::update('finance-codeweavers-username', 'lorem');
        Settings::update('finance-codeweavers-password', 'ipsum');
        Settings::update('finance-deposit_percentage', 10);

        $vehicle = Vehicle::factory()->create([
            'price' => 1000,
        ]);

        $data = [
            'term' => 60,
            //'deposit' => 100,
            'annual_mileage' => 8000,
            'credit_rating' => '',
        ];

        (new FinanceService())->request($vehicle, $data);

        // assert that the percentage deposit is overwritten by the minimum deposit
        Bus::assertDispatched(function (FetchVehicleFinanceData $job) {
            return $job->deposit == 999;
        });
    }
}
