<?php

namespace App\Modules\CatalogOffers\Http\Resources;

use App\Http\Resources\ResourceMediaEntries;
use Illuminate\Http\Resources\Json\JsonResource;

class CatalogOfferView extends JsonResource
{
    use ResourceMediaEntries;

    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load('mediaUses.media');

        $resources = $this->resource->toArray();
        $resources = array_merge($resources, $this->getMediaEntries());

        return $resources;
    }
}
