<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class KeyloopLeaseFtpSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'FTP Host',
                'config_key' => 'leasing-keyloop-fleet-kompact-ftp-host',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'FTP storage folder',
                'config_key' => 'leasing-keyloop-fleet-kompact-ftp-storage-path',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
            ],
        ];
    }
}
