<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CustomFeedExtraDataSecretSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            // Incoming
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Custom Data feed',
                'name' => 'Additional Data',
                'config_key' => 'custom-data-feed-secrets',
                'type' => 'secret',
                'value' => '',
                'order' => 90,
                'description' => 'Andy additional data required for the specific feed - e.g. credentials. JSON format',
            ],
        ];
    }
}
