<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\ApiUsage;
use Mtc\MercuryDataModels\ApiUsageSnapshot;

class CleanApiUsage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clean:api-usage';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove old entries of api usage';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        ApiUsage::query()
            ->where('created_at', '<', Carbon::now()->subMonths(3))
            ->delete();
        ApiUsageSnapshot::query()
            ->where('created_at', '<', Carbon::now()->subMonths(3))
            ->delete();
    }
}
