<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CropSizeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (app()->environment('local')) {
            return true;
        }
        $encryption_string = config('media.crop_hash') . ':' . $this->mediaUse->id
            . ':' . $this->input('width') . ':' . $this->input('height');
        return $this->mediaUse
            && $this->input('token')
            && $this->input('token') === md5($encryption_string);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tenant' => 'required',
            'token' => 'required',
            'width' => [
                'required',
                'numeric',
                'min:1',
                'max:4000',
            ],
            'height' => [
                'required',
                'numeric',
                'min:1',
                'max:4000',
            ],
        ];
    }
}
