<?php

namespace App\VehicleSpec\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Vehicle;

class FetchVehicleListSpecData implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(private readonly Collection $vehicles)
    {
        $this->onQueue('specs');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        $this->vehicles
            ->reject(fn(Vehicle $vehicle) => $vehicle->equipment()->count() && $vehicle->specs()->count())
            ->each(fn(Vehicle $vehicle) => FetchVehicleSpecData::dispatch($vehicle, true));
    }
}
