<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class LeaseImportUpdateMakeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'makes' => [
                'array',
                'required',
            ],
            'makes.*.id' => [
                'required',
            ],
            'makes.*.keyloop_import_enabled' => [
                'required',
            ],
        ];
    }
}
