<?php

namespace App\Jobs;

use App\Contracts\SalesChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ExportToSalesChannelsJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly SalesChannel $channel)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->channel->runScheduledExport();
    }
}
