<?php

namespace App\Modules\Leasing;

use App\Contracts\LeaseDataProvider;
use App\Facades\Settings;
use Illuminate\Support\Facades\Storage;

class KeyloopFleetKompact implements LeaseDataProvider
{
    public function enabled(): bool
    {
        return Settings::get('leasing-keyloop-fleet-kompact-enabled') ?? false;
    }

    public function name(): string
    {
        return 'Keyloop Fleet Kompact';
    }

    public function runScheduledImport(): void
    {
        if (Settings::get('leasing-keyloop-fleet-kompact-enabled') == false) {
            return;
        }

        collect(Storage::disk('autonomy-ftp')->files())
            ->each(fn($file) => Storage::disk('local')->put($file, Storage::disk('autonomy-ftp')->get($file)))
            ->map(fn($filename) => match ($filename) {
                'JATO_DDvaria.csv' => new KeyloopFleetKompactVariantImporter($filename, 1),
                'JATO_RV.csv' => new KeyloopFleetKompactResidualValueImporter($filename),
                'JATO_DDoptns.csv' => new KeyloopFleetKompactOptionImporter($filename),
                'option_categories.csv' => new KeyloopFleetKompactOptionCategoryImporter($filename),
                'JATO_DDopprc.csv' => new KeyloopFleetKompactOptionPriceImporter($filename),
                'JATO_oprel.csv' => new KeyloopFleetKompactPriceMapImporter($filename),
                'JATO_DDspecs.csv' => new KeyloopFleetKompactVariantOptionMapImporter($filename),
                'JATO_DDcolor.csv' => new KeyloopFleetKompactColourImporter($filename),
                'JATO_FQdiscs.csv' => new KeyloopFleetKompactDiscountImporter($filename),
                default => null,
            })
            ->filter(fn($importer) => is_a($importer, KeyloopFleetKompactImporterBase::class))
            ->sortBy(fn(KeyloopFleetKompactImporterBase $importer) => $importer->sort_order)
            ->each(function (KeyloopFleetKompactImporterBase $importer) {
                $importer->importFile();
                $this->cleanup($importer->filename);
            });
    }

    private function cleanup(string $file): void
    {
        //
    }
}
