<?php

namespace App\Reporting;

use App\Contracts\ReportTile;
use App\TaxonomyMap;

class UnmappedTaxonomyCountTile extends ReportTile
{
    private $value;

    public function __construct()
    {
    }

    public function name(): string
    {
        return __('taxonomies.unmapped');
    }

    public function value(): mixed
    {
        if (empty($this->value)) {
            $this->value = TaxonomyMap::query()->whereNull('taxonomy_id')->count();
        }
        return $this->value;
    }

    public function subtitle(): string
    {
        return '';
    }

    public function difference(): mixed
    {
        return 0;
    }

    public function secondaryValue(): mixed
    {
        return '';
    }

    public function secondaryValueName(): string
    {
        return '';
    }

    public function differenceType(): string
    {
        return $this->value > 0 ? 'negative' : 'noChange';
    }
}
