<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ReservationConfirmationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Mark vehicle as reserved when payment confirmed',
                'config_key' => 'mark-vehicle-reserved-on-confirmation',
                'type' => 'boolean',
                'value' => true,
                'description' => 'When payment for reservation is taken, marks vehicle with reserved flag',
                'order' => 40,
            ],
        ];
    }
}
