<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Mtc\MercuryDataModels\SeoRedirect;

class SeoRedirectsImported extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::MARKETING;
    }

    public function key(): string
    {
        return 'redirects_imported';
    }

    public function requiresManualConfirm(): bool
    {
        return true;
    }

    public function handle(): bool
    {
        return false;
    }

    public function name(): string
    {
        return __('go-live.names.' . $this->key(), [
            'seo_redirect_count' => SeoRedirect::query()->count(),
            'verified_redirects' => SeoRedirect::query()->where('verified', 1)->count(),
        ]);
    }
}
