<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;

class SiteAppleTouchCheck extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'apple_touch';
    }

    public function handle(): bool
    {
        $has_icon = !empty(Settings::get('site-apple-touch-icon'));
        if (!$has_icon) {
            $this->failure_reason = __('go-live.errors.no-apple-touch-icon');
        }
        return $has_icon;
    }
}
