<?php

namespace App\Modules\Stock\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MotordatStockRecord extends Model
{
    use HasFactory;

    protected $connection = 'motordat';

    protected $table = 'stock';

    protected $primaryKey = 'Id';

    public function images(): HasMany
    {
        return $this->hasMany(MotordatStockImages::class, 'VehicleId');
    }

    public function specs(): HasMany
    {
        return $this->hasMany(MotordatStockTechnicalData::class, 'VehicleId');
    }

    public function features(): HasMany
    {
        return $this->hasMany(MotordatStockFeatures::class, 'VehicleId');
    }

    public function standardEquipment(): HasMany
    {
        return $this->hasMany(MotordatStockStandardEquipment::class, 'VehicleId');
    }

    public function optionalEquipment(): HasMany
    {
        return $this->hasMany(MotordatStockOptionalEquipment::class, 'VehicleId');
    }
}
