<?php

namespace App\Reporting\StatsModels;

use App\Contracts\StatsModel;
use Carbon\Carbon;
use Mtc\Crm\Models\Enquiry;

class EnquiriesPerDay implements StatsModel
{
    /**
     * @return string
     */
    public function getKey(): string
    {
        return 'enquiries';
    }

    /**
     * @param Carbon $date
     * @return int
     */
    public function getValue(Carbon $date): mixed
    {
        $day_range = [
            $date->startOfDay()->format('Y-m-d H:i:s'),
            $date->endOfDay()->format('Y-m-d H:i:s')
        ];

        return Enquiry::query()
            ->whereBetween('created_at', $day_range)
            ->count();
    }
}
