<?php

namespace Tests\Tenant;

use App\Facades\Feature;
use App\Facades\Settings;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleSavings\VehicleSavingsHelper;
use Tests\TenantTestCase;

class SavingsFeatureTest extends TenantTestCase
{

    public function testPeterVardyDealershipSavings()
    {
        $this->enablePVSavingsMode();

        Dealership::factory()->create([
            'id' => 1,
            'location_stock' => 'PA'
        ]);

        Dealership::factory()->create([
            'id' => 2,
            'location_stock' => 'PP'
        ]);

        Dealership::factory()->create([
            'id' => 3,
            'location_stock' => 'BE'
        ]);

        $vehicle_porsche_aberdeen = Vehicle::factory()->create([
            'dealership_id' => 1
        ]);

        $vehicle_porsche_perth = Vehicle::factory()->create([
            'dealership_id' => 2
        ]);

        $vehicle_bmw = Vehicle::factory()->create([
            'dealership_id' => 3
        ]);

        Feature::setEnabled(tenant(), ['savings_type_peter_vardy']);
        $calculator = VehicleSavingsHelper::getEnabledCalculator();

        $this->assertFalse($calculator->VehicleIsEligibleForSavings($vehicle_porsche_aberdeen));
        $this->assertFalse($calculator->VehicleIsEligibleForSavings($vehicle_porsche_perth));
        $this->assertTrue($calculator->VehicleIsEligibleForSavings($vehicle_bmw));
    }

    private function enablePVSavingsMode()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'vehicle-savings-type',
            'value' => 'peter-vardy',
            'type' => 'string',
        ]);
    }
}
