<?php

namespace App\Http\Resources;

use App\TierHelper;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Str;
use JsonSerializable;

class ReplacementListResource extends JsonResource
{
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'replacements' => $this->resource
                ->map(fn($replacement) => [
                    'id' => $replacement->id,
                    'original' => $replacement->original,
                    'replacement' => $replacement->replacement,
                    'type' => $replacement->type,
                    'type_label' => $replacement->type_label,
                ]),
        ];
    }
}
