<?php

namespace App\ImportMaps;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Vehicle;

class VehicleImportMap
{
    /**
     * Report name
     *
     * @return string
     */
    public function name(): string
    {
        return 'Vehicles';
    }

    /**
     * Columns that can be used
     *
     * @return string[]
     */
    public function columns(): array
    {
        return [
            'uuid' => 'Unique Identifier',
            'registration_number' => 'Registration number',
            'vin' => 'VIN',
            'is_published' => 'Is Published',
            'is_sold' => 'Is Sold',
            'is_new' => 'Is New',
            'is_demo' => 'Is Demo',
            'is_reserved' => 'Is Reserved',
            'type' => 'Type (Car/LCV)',
            'title' => 'Title',
            'derivative' => 'Derivative',
            'make_id' => 'Vehicle make',
            'model_id' => 'Vehicle model',
            'fuel_type_id' => 'Fuel Type',
            'drivetrain_id' => 'Drivetrain',
            'transmission_id' => 'Transmission',
            'dealership_id' => 'Dealership',
            'body_style_id' => 'Body Style',
            'price' => 'Price',
            'monthly_price' => 'Monthly Price',
            'deposit' => 'Deposit',
            'colour' => 'Colour',
            'odometer_mi' => 'Odometer (miles)',
            'odometer_km' => 'Odometer (km)',
            'engine_size_cc' => 'Engine size (cc)',
            'co2' => 'CO2',
            'mpg' => 'MPG',
            'door_count' => 'Door count',
            'seats' => 'Seat count',
            'manufacture_year' => 'Manufacture year',
            'previous_owner_count' => 'Previous owner count',
            'images' => 'Image URLs',
            'features' => 'Features',
            'specs' => 'Specs',
            'tech_data' => 'Tech data',
            'main_video_url' => 'Video URL',
            'cap_id' => 'CAP ID',
            'auto_trader_id' => 'AutoTrader ID',
            'first_registration_date' => 'First registration date',
            'available_date' => 'Date when vehicle becomes available',
            'stock_arrival_date' => 'Stock arrival date',
            'description' => ' Description text',
            'trim' => ' Trim',
            'attention_grabber' => 'Attention grabber text',
            'vehicle_length' => 'Vehicle length (mm)',
            'exterior_video_url' => 'Exterior video URL',
            'interior_video_url' => 'Interior video URL',
            'battery_range' => '[EV] Battery range',
            'battery_capacity_kwh' => '[EV] Battery capacity (kWh)',
            'battery_usable_capacity_kwh' => '[EV] Battery usable capacity (kWh)',
            'battery_charge_time' => '[EV] Battery charge time',
            'battery_quick_charge_time' => '[EV] Battery quick charge time',
            'battery_quick_charge_level' => '[EV] Battery level at end of quick charge',
            'wheelbase_type' => 'Wheelbase (mm)',
            'wheelbase_mm' => 'Wheelbase (mm)',
            'payload_kg' => 'Payload (kg)',
            'gross_vehicle_weight_kg' => 'Gross vehicle weight (kg)',
            'bhp' => 'BHP',
            'is_vat_applicable' => 'Is VAT applicable',
            'personalized_number_plate' => 'Has custom(non-standard) number plate',
        ];
    }

    /**
     * Start a query
     *
     * @return Builder
     */
    public function query(): Builder
    {
        return Vehicle::query();
    }
}
