<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;

class ImportMap extends Model
{
    use HasFactory;
    use EnsuresSlug;

    protected $fillable = [
        'name',
        'slug',
        'type',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saving(function (self $dealership) {
            $dealership->ensureSlug();
        });
    }

    public function fields(): HasMany
    {
        return $this->hasMany(ImportMapField::class, 'map_id');
    }
}
