<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class SettingTypeRule implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return in_array($value, [
            'boolean',
            'image',
            'media',
            'secret',
            'string',
            'int',
            'verify',
        ], true);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message(): string
    {
        return 'A valid setting type must be provided.';
    }
}
