<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'auto-trader' => [
        'merchant_id' => env('AUTO_TRADER_MERCHANT_ID'),
        'use_live_api' => env('AUTO_TRADER_USE_LIVE_API'),
        'api_key' => env('AUTO_TRADER_API_KEY'),
        'api_secret' => env('AUTO_TRADER_API_SECRET'),
    ],

    'auto-trader-hub' => [
        'url' => env('AUTO_TRADER_HUB_URL', 'https://autotrader.mtcassets.com'),
        'api_key' => env('AUTO_TRADER_HUB_API_KEY'),
    ],

    'sync' => [
        'prod_url' => 'https://my.getautonomy.co.uk',
        'aws_url' => 'https://my.autonomy.mtcserver.com',
        'vps_url' => 'https://my.autonomystage.mtcserver.com',
    ],

    'silver-bullet' => [
        'media_size' => '1000x1000',
        'store-export-logs' => true,
    ],

    'enquiry-max' => [
        'mode' => env('ENQUIRY_MAX_API_MODE', 'live'),
    ],

    'dealer-web' => [
        'endpoint' => env('DEALERWEB_LMS_ENDPOINT', 'https://services.dealerweb.app/LMS/lms.asmx'),
    ],

    'sales-channels' => [
        'car-guru' => \App\Modules\SalesChannels\CarGuru::class,
        'motors-co-uk' => \App\Modules\SalesChannels\MotorsCoUk::class,
    ],

    'currency' => [
        'endpoint' => 'http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml'
    ],

    'graph' => [
        'domain' => env('GRAPH_SERVICE_DOMAIN', '//autonomy-stats'),
    ],

    'image-sync' => [
        'autos-on-show' => [
            'live_api' => env('AUTOS_ON_SHOW_LIVE', true),
            'notification_token' => env('AUTOS_ON_SHOW_NOTIFICATION_TOKEN'),
        ],
        'auto-imaging' => [
            'key' => env('AUTO_IMAGING_AUTH_KEY'),
        ],
    ],
    'auto-trader-microservice' => [
        'api_key' => env('MTC_AUTO_TRADER_SERVICE_API_KEY'),
    ],
    'keyloop-rev8' => [
        'disk' => env('KEYLOOP_REV8_DISK', 'local'),
    ],
    'skoda' => [
       'endpoint' => 'https://www.skoda.ie/apps/stock/941/en-IE/api/'
    ],
    'open-ai' => [
        'model' => 'gpt-3.5-turbo',
        'endpoint' => 'https://api.openai.com/v1/'
    ],
    'occupop' => [
        'endpoint' => 'https://api.occupop.com/api/webhooks/jobs/'
    ],
    'autoweb' => [
        'endpoint' => 'https://api.autoweb.co.uk'
    ],
    'codeweavers' => [
        'username' => env('CODEWEAVERS_USERNAME'),
        'password' => env('CODEWEAVERS_PASSWORD'),
    ],
    'cloudflare' => [
        'email' => env('CLOUDFLARE_API_EMAIL'),
        'api_key' => env('CLOUDFLARE_API_KEY'),
    ],
];
