<?php

namespace Database\Seeders\Global;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Billable;

class PrimaryBillableSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect([
            [
                'code' => 'lite',
                'type' => 'tier',
                'name' => 'Lite Package',
                'description' => 'Excellent for small dealerships. Provides a wide set of features',
                'active' => true,
                'price' => 180,
            ],
            [
                'code' => 'standard',
                'type' => 'tier',
                'name' => 'Standard Package',
                'description' => 'Everything in Lite + 3rd parties for CRM, vehicles, newsletters, stock',
                'active' => false,
                'price' => 350,
            ],
            [
                'code' => 'pro',
                'type' => 'tier',
                'name' => 'Pro Package',
                'description' => 'Everything in Standard + Valuations, Franchises, new vehicles',
                'active' => false,
                'price' => 500,
            ],
            [
                'code' => 'enterprise',
                'type' => 'tier',
                'name' => 'Enterprise Package',
                'description' => 'Custom build',
                'active' => false,
                'price' => 0,
            ],
        ])->each(fn ($record) => Billable::query()->create($record));
    }
}
