<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MoneypennySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Moneypenny',
                'name' => 'Enabled',
                'config_key' => 'chat-moneypenny-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => 'Moneypenny live chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Moneypenny',
                'name' => 'Client Key',
                'config_key' => 'chat-moneypenny-key',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'description' => 'Moneypenny live chat integration key.',
                'validation_rules' => [
                    "required_if:values.chat-moneypenny-enabled,true"
                ]
            ],
        ];
    }
}
