<?php

namespace Tests\Feature;

use App\Http\Requests\BulkDeleteRequest;
use App\Services\BulkDeleteService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class BulkDeleteTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        Vehicle::factory(4)->create();

        $vehicles = Vehicle::query()->take(3)->get();

        $service = new BulkDeleteService();

        $request = new BulkDeleteRequest();
        $request->merge([
            'model' => 'vehicles',
            'ids' => $vehicles->pluck('id'),
        ]);
        $response = $service->delete($request);

        $this->assertEquals(3, json_decode($response->getContent())->deleted_count);
        $this->assertEquals(0, Vehicle::query()->whereIn('id', $vehicles->pluck('id'))->count());
        $this->assertEquals(1, Vehicle::query()->count());
    }
}
