<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class AutoloadItFtpSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));

        Setting::where('config_key', 'image-sync-autoloadit-endpoint')->delete();
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Autoload It',
                'name' => 'Feed ID',
                'config_key' => 'image-sync-autoloadit-feed-id',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'order' => 22,
                'description' => 'Feed ID provider by autoloadit'
            ],
        ];
    }
}
