<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarAndDrivingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Enabled',
                'config_key' => 'app-content-car-and-driving-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.caranddriving.com/" target="_blank">Car And Driving</a> video library.'
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'User ID',
                'config_key' => 'app-content-car-and-driving-user-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.app-content-car-and-driving-enabled,true"
                ]
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Video Width',
                'config_key' => 'app-content-car-and-driving-video-width',
                'type' => 'string',
                'value' => '800',
                'validation_rules' => [
                    "integer"
                ]
            ],
        ];
    }
}
