<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class S3BucketSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Custom Storage Bucket',
                'config_key' => 'filesystem-custom-s3-bucket-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'enterprise',
                'superadmin' => true,
                'description' => 'Store media files on a standalone S3 bucket (away from other sites)',
                'order' => 11,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Storage Bucket Access Key ID',
                'config_key' => 'filesystem-custom-s3-bucket-access-key-id',
                'type' => 'secret',
                'value' => '',
                'superadmin' => true,
                'min_tier' => 'enterprise',
                'order' => 12,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Storage Bucket Access Key',
                'config_key' => 'filesystem-custom-s3-bucket-access-key',
                'type' => 'secret',
                'value' => '',
                'superadmin' => true,
                'min_tier' => 'enterprise',
                'order' => 12,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Storage Bucket Region',
                'config_key' => 'filesystem-custom-s3-bucket-region',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
                'min_tier' => 'enterprise',
                'order' => 13,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Storage Bucket Name',
                'config_key' => 'filesystem-custom-s3-bucket-bucket',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
                'min_tier' => 'enterprise',
                'order' => 14,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Storage Bucket Endpoint URL',
                'config_key' => 'filesystem-custom-s3-bucket-endpoint',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
                'min_tier' => 'enterprise',
                'order' => 15,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Storage Bucket CDN Endpoint URL',
                'config_key' => 'filesystem-custom-s3-bucket-cnd-endpoint',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
                'min_tier' => 'enterprise',
                'order' => 16,
            ],
        ];
    }
}
