<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class StockImportFinanceFetchSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'DMS vehicle sync',
            'group' => 'General',
            'name' => 'Update Finance on Price Change Only',
            'config_key' => 'finance-fetch-only-on-price-change',
            'min_tier' => 'standard',
            'type' => 'boolean',
            'value' => false,
            'description' => 'Update vehicle finance only when the vehicle price has changed',
        ]);
    }
}
