<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Dealership;

class ServiceAvailabilityList extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return $this->resource->map(fn($dealership) => $this->map($dealership))->toArray();
    }

    private function map(Dealership $dealership): array
    {
        return [
            'id' => $dealership->id,
            'name' => $dealership->name,
            'metaItems' => [
                'active' => $dealership->serviceAvailability?->active ? 'Service booking active' : '',
            ],
            'has_availability' => isset($dealership->serviceAvailability->id),
        ];
    }
}
