<?php

namespace App\Mail;

use App\Facades\Settings;
use App\Facades\Site;
use App\Traits\GetsColourSettings;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Booking;
use Mtc\MercuryDataModels\GlobalContent;

class NewBookingConfirmationMail extends Mailable
{
    use Queueable;
    use SerializesModels;
    use GetsColourSettings;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(public readonly Booking $booking)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            from: new Address(config('mail.from.address'), config('mail.from.name')),
            subject: __('bookings.new-booking-confirmation'),
        );
    }

    public function content(): Content
    {
        $footerText = '';
        $globalContent = GlobalContent::query()->where('slug', 'customer-enquiry-autoresponder')->first();

        foreach ($globalContent?->content as $content) {
            if (!empty($content['children'])) {
                foreach ($content['children'] as $childContent) {
                    if ($childContent['slug'] == 'footer') {
                        $footerText = $childContent['content'];
                    }
                }
            }
        }
        return new Content(
            view: 'emails.booking.new-booking-customer',
            with: [
                'site_name' => Settings::get('app-name'),
                'site_logo' => Settings::get('site-logo'),
                'site_url' => Site::url(''),
                'site_logo_alternate' => Settings::get('site-alternate-logo'),
                'colours' => $this->getColourSettings(),
                'content' => '',
                'footer' => $footerText,
            ]
        );
    }
}
