<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferLinkUrlSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Offers',
                'name' => 'Offer page URL path',
                'config_key' => 'offers-url-path',
                'type' => 'string',
                'value' => '/offer/{{SLUG}}',
                'order' => 1,
                'min_tier' => 'enterprise',
                'description' => 'path - e.g. /offer/{{SLUG}} or /offer/{{MAKE}}/{{MODEL}}/{{SLUG}} . '
                    . 'Supports MAKE MODEL and SLUG placeholders. Used for URL generating in API, '
                    . 'must match the implementation in theme!',
            ],
        ];
    }
}
