<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Log;
use Mtc\MercuryDataModels\Finance\Contracts\ExportsStockToFinance;
use Mtc\MercuryDataModels\Finance\FinanceServiceHelper;
use Mtc\MercuryDataModels\Finance\Jobs\RunFinanceExport;

class ExportVehiclesToFinance extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'finance:export-vehicles';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Export vehicle data to CodeWeavers';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (!FinanceServiceHelper::hasEnabledProvider()) {
            return Command::SUCCESS;
        }

        $provider = FinanceServiceHelper::initializeForSite();
        if ($provider instanceof ExportsStockToFinance && Settings::get('finance-export-to-provider')) {
            Log::info('Finance export triggered for ' . tenant('id') . ' via scheduled task');
            $this->output->info('Running export for ' . tenant('id'));
            $this->dispatch(new RunFinanceExport($provider));
        }

        return Command::SUCCESS;
    }
}
