@extends('crm::emails.flex-auto.layout', [
    'subject' => $enquiry->subject ?? 'Thank you for your enquiry',
    'site_name' => $site_name,
    'site_logo' => $site_logo,
    'site_url' => $site_url,
    'colours' => $colours,
])

@section('content')
    @if($enquiry->valuation)
    <!-- VALUATION BLOCK -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" width="100%">
                            <tr>
                                <td background="{{ config('app.url') . '/api/assets/flex-auto/valuation-background-image.png' }}" bgcolor="#4F4F4F" valign="bottom" style="border-radius: 10px 10px 0px 0px;" height="175">
                                    <!--[if gte mso 9]>
                                                <v:rect xmlns:v="urn:schemas-microsoft-com:vml" fill="true" stroke="false" style="mso-width-percent:1000; height:175px;">
                                                    <v:fill type="tile" src="{{ config('app.url') . '/api/assets/flex-auto/valuation-background-image.png' }}" color="#4F4F4F" />
                                                    <v:textbox style="mso-fit-shape-to-text:true" inset="0,0,0,0">
                                                <![endif]-->
                                    <div>
                                        <table cellpadding="40" cellspacing="0" border="0" width="100%">
                                            <tr>
                                                <td valign="top" align="left">
                                                    <p style="color:#FFFFFF; margin:0; font-size:40px; font-weight:700; letter-spacing:-0.8px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Your valuation</p>
                                                </td>
                                                <td valign="top" align="right">
                                                    <p style="color:#FFFFFF; margin:0; font-size:40px; font-weight:700; letter-spacing:-0.8px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">£{{ number_format($enquiry->valuation?->retail_price) }}</p>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!--[if gte mso 9]>
                                    </v:textbox>
                                    </v:rect>
                                    <![endif]-->
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                            </tr>
                            <tr>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                        <tr>
                                            <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                            <td valign="top">
                                                <table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="#F2F5F7" style="background-color:#F2F5F7;">
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Vehicle
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $enquiry->valuation?->make }}
                                                                {{ $enquiry->valuation?->model }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="10"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Mileage
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ number_format($enquiry->valuation?->mileage) }} miles
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Registration
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $enquiry->valuation?->registration }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;border-radius:0px 0px 10px 10px;"></td>
                            </tr>
                        </table>
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
                <tr>
                    <td valign="top" height="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <!-- END OF VALUATION BLOCK -->
    @endif
    <!-- CONTENT AREA -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        {!! str_replace(
                            [
                                '<p>',
                                '<h1>',
                                '<h2>',
                                '<h3>',
                                '<h4>',
                                '<h5>',
                                '<h6>',
                                '<ul>',
                                '<li>',
                                '<ol>',
                            ],
                            [
                                '<p style="color:#324E60; margin:0 0 20px; font-size:18px; font-weight:400; line-height:26px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h2 style="color:#324E60; margin:0 0 10px; font-size:32px; line-height:36px; font-weight:700; letter-spacing:-0.64px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h3 style="color:#324E60; margin:0 0 10px; font-size:24px; line-height:28px; font-weight:700; letter-spacing:-0.48px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h4>',
                                '<h5>',
                                '<h6>',
                                '<ul>',
                                '<li>',
                                '<ol>',
                            ],
                        $content) !!}
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td valign="top" height="50"></td>
    </tr>
    <!-- END OF CONTENT AREA -->
@endsection

@section('footer')
    <tr>
        <td colspan="2" align="center" class="smallText">
            {!! str_replace(
                [
                    '<p>',
                    '<h1>',
                    '<h2>',
                    '<h3>',
                    '<h4>',
                    '<h5>',
                    '<h6>',
                    '<ul>',
                    '<li>',
                    '<ol>',
                    '<td>',
                ],
                [
                    '<p style="color:#324E60; margin:0; font-size:12px; font-weight:500; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h2 style="color:#324E60; margin:0 0 10px; font-size:32px; line-height:36px; font-weight:700; letter-spacing:-0.64px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h3 style="color:#324E60; margin:0 0 10px; font-size:24px; line-height:28px; font-weight:700; letter-spacing:-0.48px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h4>',
                    '<h5>',
                    '<h6>',
                    '<ul>',
                    '<li>',
                    '<ol>',
                    '<td valign="top" width="20">',
                ],
            $footer) !!}
        </td>
    </tr>
@endsection
