<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ImageSyncExcludeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'General',
                'name' => 'Exclude vehicles with status Sold',
                'config_key' => 'image-sync-exclude-sold',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'General',
                'name' => 'Exclude vehicles with status Reserved',
                'config_key' => 'image-sync-exclude-reserved',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
