<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MotorsSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'Enabled',
                'config_key' => 'stock-motors-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => 'Retrieve stock through FTP that is passed from Motors',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'Only import vehicles with price set',
                'config_key' => 'stock-motors-sync-with-price',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'FTP Username',
                'config_key' => 'stock-motors-ftp-username',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'FTP Username for ftp.getautonomy.co.uk'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'FTP Password',
                'config_key' => 'stock-motors-ftp-password',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'FTP Password for ftp.getautonomy.co.uk'
            ],
        ];
    }
}
