<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\MotorsCoUkExportJob;
use App\Modules\SalesChannels\MotorsCoUk;
use Database\Seeders\Tenant\MotorsCoUkExportSeeder;
use Illuminate\Support\Facades\Queue;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class MotorsCoUkExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('motors-co-uk-export');
        $this->seed(MotorsCoUkExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-motors-co-uk-file-name', 'foo.csv');

        (new MotorsCoUkExportJob())->handle();

        Storage::disk('motors-co-uk-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'motors-co-uk')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Storage::fake('motors-co-uk-export');
        $this->seed(MotorsCoUkExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-motors-co-uk-file-name', 'foo.csv');
        Settings::update('sales-channels-motors-co-uk-enabled', true);
        Queue::fake();

        app(MotorsCoUk::class)->runScheduledExport();

        Queue::assertPushed(MotorsCoUkExportJob::class);
    }
}
