<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class NumericTypeHasNumericValue implements ValidationRule
{
    public function validate(string $attribute, mixed $rules, Closure $fail): void
    {
        foreach ($rules as $rule) {
            if (
                (
                    $rule['value_data_type'] == 'integer'
                    || $rule['value_data_type'] == 'decimal'
                    || $rule['value_data_type'] == 'float'
                )
                && !empty($rule['condition_value'])
                && !is_numeric($rule['condition_value'])
            ) {
                $fail($rule['name'] . ' must be numeric');
            }
        }
    }
}
