<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BrandingSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Primary Colour',
                'config_key' => 'app-primary-colour',
                'type' => 'string',
                'value' => '#3C576B',
                'description' => 'Primary colour as a hex code - #FF7823',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Secondary Colour',
                'config_key' => 'app-secondary-colour',
                'type' => 'string',
                'value' => '#76AFDC',
                'description' => 'Secondary colour as a hex code',
                'order' => 2,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Tertiary Colour',
                'config_key' => 'app-tertiary-colour',
                'type' => 'string',
                'value' => '#FF7823',
                'description' => 'Tertiary colour as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Success Colour',
                'config_key' => 'app-success-colour',
                'type' => 'string',
                'value' => '#98EBD3',
                'description' => 'Success messaging colour as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Error Colour',
                'config_key' => 'app-error-colour',
                'type' => 'string',
                'value' => '#F54B64',
                'description' => 'Error messaging colour as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Information Colour',
                'config_key' => 'app-information-colour',
                'type' => 'string',
                'value' => '#FFF05A',
                'description' => 'Information element/button colour as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Text Colour',
                'config_key' => 'app-text-colour',
                'type' => 'string',
                'value' => '#20292E',
                'description' => 'Primary text colour (e.g. titles) as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Secondary text Colour',
                'config_key' => 'app-subtext-colour',
                'type' => 'string',
                'value' => '#7a7e84',
                'description' => 'Secondary text colour (less emphasised) as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Dark Colour',
                'config_key' => 'app-layer-dark-colour',
                'type' => 'string',
                'value' => '#20292E',
                'description' => 'Dark colour to use in site elements as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Accent Colour',
                'config_key' => 'app-layer-accent-colour',
                'type' => 'string',
                'value' => '#EEEEEE',
                'description' => 'Accent colour to use in site elements as a hex code',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding',
                'name' => 'Light Colour',
                'config_key' => 'app-layer-light-colour',
                'type' => 'string',
                'value' => '#F5F5F7',
                'description' => 'Light colour to use in site elements as a hex code',
                'order' => 1,
            ],
        ];
    }
}
