<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PyxelSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Pyxel',
                'name' => 'Enabled',
                'config_key' => 'image-sync-pyxel-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Pyxel.com image provider. After enabling locations need account key assigned',
            ],
        ];
    }
}
