<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateReservationRequest;
use App\Http\Resources\ReservationList;
use App\Http\Resources\ReservationView;
use Illuminate\Http\Request;
use Mtc\VehicleReservations\Reservation;
use Mtc\VehicleReservations\ReservationRepository;

class ReservationController extends Controller
{
    public function index()
    {
        return new ReservationList(
            Reservation::query()->with('vehicle')->whereNotNull('confirmed_at')->latest()->paginate()
        );
    }

    public function show(Reservation $reservation)
    {
        return new ReservationView($reservation);
    }

    public function update(UpdateReservationRequest $request, Reservation $reservation): ReservationView
    {
        $reservation->update($request->validated());
        return new ReservationView($reservation);
    }

    public function destroy(Reservation $reservation): ReservationList
    {
        $reservation->update(['status' => 'cancelled']);

        $vehicleHasNoReservation = $reservation->vehicle->reservations()
            ->whereNotIn('status', ['pending', 'cancelled'])
            ->exists();
        if ($vehicleHasNoReservation) {
            $reservation->vehicle->update(['is_reserved' => false]);
        }

        return $this->index($reservation);
    }
}
