<?php

namespace App\Jobs;

use App\Facades\Settings;
use App\Services\AutoTrader;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Dealership;

class FetchAutoTraderPerformanceData implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        $this->onQueue('specs');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        /** @var AutoTrader $api */
        $api = App::make(AutoTrader::class);
        Dealership::query()
            ->whereHas('vehicles')
            ->get()
            ->map(fn (Dealership $dealership) => $dealership['data']['auto-trader-location-id'] ?? null)
            ->push(Settings::get('auto-trader-advertiser-id'))
            ->filter()
            ->each(fn($advertiserId) => $api->getAutoTraderData($advertiserId));
    }
}
