<?php

namespace App\Master\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Master\Http\Requests\SiteDomainRequest;
use Illuminate\Database\Eloquent\Collection;
use Stancl\Tenancy\Database\Models\Domain;

class SiteDomainController extends Controller
{
    public function listDomains(SiteDomainRequest $request)
    {
        return Domain::query()
            ->with('tenant')
            ->get()
            ->groupBy(fn(Domain $domain) => $domain->tenant->theme_name ?? 'base-theme')
            ->map(fn(Collection $collection) => $collection->pluck('domain'))
            ->put('admin-ui', [str_replace(['https://', 'http://'], '', config('app.url'))]);
    }
}
