<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderEquipmentSyncFlags extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Sync manufacturer standard features to equipment list',
                'config_key' => 'autotrader-stock-sync-standard-features',
                'type' => 'boolean',
                'value' => false,
                'order' => 22,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Sync manufacturer optional features to equipment list',
                'config_key' => 'autotrader-stock-sync-optional-features',
                'type' => 'boolean',
                'value' => false,
                'order' => 23,
            ],
        ];
    }
}
