<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class HideVansFromListing extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Vehicles',
                'name' => 'Hide vans from listing page',
                'config_key' => 'hide-vans-from-listing',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
