<?php

namespace App;

use App\Http\Requests\SearchRequest;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\GlobalContent;
use Mtc\MercuryDataModels\Menu;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

class AdminSearchRepository
{
    public function search(SearchRequest $request)
    {
        $type = $request->input('type') ?? 'all';
        return collect([

            'enquiries' => in_array($type, ['all', 'enquiry']) ? $this->enquiries($request) : null,
            'vehicles' => in_array($type, ['all', 'vehicle']) ? $this->vehicles($request) : null,
            'pages' => in_array($type, ['all', 'page']) ? $this->pages($request) : null,
            'offers' => in_array($type, ['all', 'offer']) ? $this->offers($request) : null,
            'new-car' => in_array($type, ['all', 'new-car']) ? $this->newCars($request) : null,
            'global' => in_array($type, ['all', 'global']) ? $this->globalContent($request) : null,
            'menu' => in_array($type, ['all', 'global']) ? $this->menus($request) : null,
            'dealership' => in_array($type, ['all', 'global']) ? $this->dealerships($request) : null,
            'form' => in_array($type, ['all', 'global']) ? $this->form($request) : null,
        ])
            ->filter()
            ->flatten(1)
            ->unique();
    }

    private function enquiries(SearchRequest $request): Collection
    {
        return Enquiry::query()
            ->where('title', 'like', $request->getTerm())
            ->get();
    }

    private function vehicles(SearchRequest $request): Collection
    {
        return Vehicle::query()
            ->whereFullText('search_content', $request->getTerm())
            ->orWhere('vrm_condensed', $request->getTerm(false))
            ->orWhere('registration_number', $request->getTerm(false))
            ->get();
    }

    private function pages(SearchRequest $request): Collection
    {
        return Page::query()
            ->with('categories')
            ->whereFullText('search_content', $request->getTerm())
            ->orWhere('title', 'like', $request->getTerm())
            ->get();
    }

    private function newCars(SearchRequest $request): Collection
    {
        return NewCar::query()
            ->whereFullText('search_content', $request->getTerm())
            ->orWhere('name', 'like', $request->getTerm())
            ->get();
    }

    private function offers(SearchRequest $request): Collection
    {
        return VehicleOffer::query()
            ->whereFullText('search_content', $request->getTerm())
            ->orWhere('name', 'like', $request->getTerm())
            ->get();
    }

    private function globalContent(SearchRequest $request): Collection
    {
        return GlobalContent::query()
            ->where('name', 'like', $request->getTerm())
            ->get();
    }

    private function menus(SearchRequest $request): Collection
    {
        return Menu::query()
            ->where('title', 'like', $request->getTerm())
            ->get();
    }

    private function dealerships(SearchRequest $request): Collection
    {
        return Dealership::query()
            ->where('name', 'like', $request->getTerm())
            ->get();
    }

    private function form(SearchRequest $request): Collection
    {
        return Form::query()
            ->where('name', 'like', $request->getTerm())
            ->get();
    }
}
