<?php

namespace App\Http\Controllers;

use App\Http\Requests\ValuationRequest;
use App\Http\Resources\ValuationList;
use App\Http\Resources\ValuationResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Mtc\MercuryDataModels\VehicleValuation;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationController extends Controller
{
    public function __construct()
    {
        $this->middleware([
            'permission:view-valuations',
        ]);
    }

    public function index(Request $request)
    {
        return new ValuationList(VehicleValuation::query()
            ->setSortBy($request->input('sort_by', 'id_desc'))
            ->setFilters($request->input('filters', []))
            ->paginate());
    }

    public function store(ValuationRequest $request)
    {
        if (Valuation::hasEnabledDriver() !== true) {
            return response([
                'message' => 'No valuation service is enabled'
            ], 422);
        }
        try {
            $valuation = Valuation::get($request->input('registration_number'), $request->input('mileage'));
            if ($valuation->wasRecentlyCreated) {
                $valuation->update([
                    'user_id' => Auth::id(),
                ]);
            }
            return new ValuationResource($valuation);
        } catch (\Exception $exception) {
            throw ValidationException::withMessages([$exception->getMessage()]);
        }
    }

    public function show(VehicleValuation $valuation)
    {
        return new ValuationResource($valuation);
    }
}
